/*
 * Decompiled with CFR 0.152.
 */
package biz.source_code.miniTemplator;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MiniTemplatorParser {
    private static final int maxNestingLevel = 20;
    private static final int maxCondLevels = 20;
    private static final int maxInclTemplateSize = 1000000;
    public String templateText;
    private HashSet<String> conditionFlags;
    public String[] varTab;
    public int varTabCnt;
    private HashMap<String, Integer> varNameToNoMap;
    public VarRefTabRec[] varRefTab;
    public int varRefTabCnt;
    public BlockTabRec[] blockTab;
    public int blockTabCnt;
    private HashMap<String, Integer> blockNameToNoMap;
    private int currentNestingLevel;
    private int[] openBlocksTab;
    private int condLevel;
    private boolean[] condEnabled;
    private boolean[] condPassed;
    private MiniTemplator miniTemplator;
    private boolean resumeCmdParsingFromStart;

    public MiniTemplatorParser(String string, Set<String> set, MiniTemplator miniTemplator) throws MiniTemplator.TemplateSyntaxException {
        this.templateText = string;
        this.conditionFlags = this.createConditionFlagsSet(set);
        this.miniTemplator = miniTemplator;
        this.parseTemplate();
        this.miniTemplator = null;
    }

    private HashSet<String> createConditionFlagsSet(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String string : set) {
            hashSet.add(string.toUpperCase());
        }
        return hashSet;
    }

    private void parseTemplate() throws MiniTemplator.TemplateSyntaxException {
        this.initParsing();
        this.beginMainBlock();
        this.parseTemplateCommands();
        this.endMainBlock();
        this.checkBlockDefinitionsComplete();
        if (this.condLevel != -1) {
            throw new MiniTemplator.TemplateSyntaxException("$if without matching $endIf.");
        }
        this.parseTemplateVariables();
        this.associateVariablesWithBlocks();
        this.terminateParsing();
    }

    private void initParsing() {
        this.varTab = new String[64];
        this.varTabCnt = 0;
        this.varNameToNoMap = new HashMap();
        this.varRefTab = new VarRefTabRec[64];
        this.varRefTabCnt = 0;
        this.blockTab = new BlockTabRec[16];
        this.blockTabCnt = 0;
        this.currentNestingLevel = 0;
        this.blockNameToNoMap = new HashMap();
        this.openBlocksTab = new int[21];
        this.condLevel = -1;
        this.condEnabled = new boolean[20];
        this.condPassed = new boolean[20];
    }

    private void terminateParsing() {
        this.openBlocksTab = null;
    }

    private void beginMainBlock() {
        int n2 = this.registerBlock(null);
        BlockTabRec blockTabRec = this.blockTab[n2];
        blockTabRec.tPosBegin = 0;
        blockTabRec.tPosContentsBegin = 0;
        this.openBlocksTab[this.currentNestingLevel] = n2;
        ++this.currentNestingLevel;
    }

    private void endMainBlock() {
        BlockTabRec blockTabRec = this.blockTab[0];
        blockTabRec.tPosContentsEnd = this.templateText.length();
        blockTabRec.tPosEnd = this.templateText.length();
        blockTabRec.definitionIsOpen = false;
        --this.currentNestingLevel;
    }

    private void parseTemplateCommands() throws MiniTemplator.TemplateSyntaxException {
        int n2;
        int n3 = 0;
        while ((n2 = this.templateText.indexOf("<!--", n3)) != -1) {
            this.conditionalExclude(n3, n2);
            n3 = this.templateText.indexOf("-->", n2);
            if (n3 == -1) {
                throw new MiniTemplator.TemplateSyntaxException("Invalid HTML comment in template at offset " + n2 + ".");
            }
            String string = this.templateText.substring(n2 + 4, (n3 += 3) - 3);
            this.resumeCmdParsingFromStart = false;
            this.processTemplateCommand(string, n2, n3);
            if (!this.resumeCmdParsingFromStart) continue;
            n3 = n2;
        }
    }

    private void processTemplateCommand(String string, int n2, int n3) throws MiniTemplator.TemplateSyntaxException {
        int n4 = MiniTemplatorParser.skipBlanks(string, 0);
        if (n4 >= string.length()) {
            return;
        }
        int n5 = MiniTemplatorParser.skipNonBlanks(string, n4);
        String string2 = string.substring(n4, n5);
        String string3 = string.substring(n5);
        if (string2.equalsIgnoreCase("$beginBlock")) {
            this.processBeginBlockCmd(string3, n2, n3);
        } else if (string2.equalsIgnoreCase("$endBlock")) {
            this.processEndBlockCmd(string3, n2, n3);
        } else if (string2.equalsIgnoreCase("$include")) {
            this.processIncludeCmd(string3, n2, n3);
        } else if (string2.equalsIgnoreCase("$if")) {
            this.processIfCmd(string3, n2, n3);
        } else if (string2.equalsIgnoreCase("$elseIf")) {
            this.processElseIfCmd(string3, n2, n3);
        } else if (string2.equalsIgnoreCase("$else")) {
            this.processElseCmd(string3, n2, n3);
        } else if (string2.equalsIgnoreCase("$endIf")) {
            this.processEndIfCmd(string3, n2, n3);
        } else if (string2.startsWith("$") && !string2.startsWith("${")) {
            throw new MiniTemplator.TemplateSyntaxException("Unknown command \"" + string2 + "\" in template at offset " + n2 + ".");
        }
    }

    private void processBeginBlockCmd(String string, int n2, int n3) throws MiniTemplator.TemplateSyntaxException {
        if (this.conditionalExclude(n2, n3)) {
            return;
        }
        int n4 = MiniTemplatorParser.skipBlanks(string, 0);
        if (n4 >= string.length()) {
            throw new MiniTemplator.TemplateSyntaxException("Missing block name in $BeginBlock command in template at offset " + n2 + ".");
        }
        int n5 = MiniTemplatorParser.skipNonBlanks(string, n4);
        String string2 = string.substring(n4, n5);
        if (!MiniTemplatorParser.isRestOfStringBlank(string, n5)) {
            throw new MiniTemplator.TemplateSyntaxException("Extra parameter in $BeginBlock command in template at offset " + n2 + ".");
        }
        int n6 = this.registerBlock(string2);
        BlockTabRec blockTabRec = this.blockTab[n6];
        blockTabRec.tPosBegin = n2;
        blockTabRec.tPosContentsBegin = n3;
        this.openBlocksTab[this.currentNestingLevel] = n6;
        ++this.currentNestingLevel;
        if (this.currentNestingLevel > 20) {
            throw new MiniTemplator.TemplateSyntaxException("Block nesting overflow for block \"" + string2 + "\" in template at offset " + n2 + ".");
        }
    }

    private void processEndBlockCmd(String string, int n2, int n3) throws MiniTemplator.TemplateSyntaxException {
        if (this.conditionalExclude(n2, n3)) {
            return;
        }
        int n4 = MiniTemplatorParser.skipBlanks(string, 0);
        if (n4 >= string.length()) {
            throw new MiniTemplator.TemplateSyntaxException("Missing block name in $EndBlock command in template at offset " + n2 + ".");
        }
        int n5 = MiniTemplatorParser.skipNonBlanks(string, n4);
        String string2 = string.substring(n4, n5);
        if (!MiniTemplatorParser.isRestOfStringBlank(string, n5)) {
            throw new MiniTemplator.TemplateSyntaxException("Extra parameter in $EndBlock command in template at offset " + n2 + ".");
        }
        int n6 = this.lookupBlockName(string2);
        if (n6 == -1) {
            throw new MiniTemplator.TemplateSyntaxException("Undefined block name \"" + string2 + "\" in $EndBlock command in template at offset " + n2 + ".");
        }
        --this.currentNestingLevel;
        BlockTabRec blockTabRec = this.blockTab[n6];
        if (!blockTabRec.definitionIsOpen) {
            throw new MiniTemplator.TemplateSyntaxException("Multiple $EndBlock command for block \"" + string2 + "\" in template at offset " + n2 + ".");
        }
        if (blockTabRec.nestingLevel != this.currentNestingLevel) {
            throw new MiniTemplator.TemplateSyntaxException("Block nesting level mismatch at $EndBlock command for block \"" + string2 + "\" in template at offset " + n2 + ".");
        }
        blockTabRec.tPosContentsEnd = n2;
        blockTabRec.tPosEnd = n3;
        blockTabRec.definitionIsOpen = false;
    }

    private int registerBlock(String string) {
        BlockTabRec blockTabRec;
        int n2 = this.blockTabCnt++;
        if (this.blockTabCnt > this.blockTab.length) {
            this.blockTab = (BlockTabRec[])MiniTemplatorParser.resizeArray(this.blockTab, 2 * this.blockTabCnt);
        }
        this.blockTab[n2] = blockTabRec = new BlockTabRec();
        blockTabRec.blockName = string;
        blockTabRec.nextWithSameName = string != null ? this.lookupBlockName(string) : -1;
        blockTabRec.nestingLevel = this.currentNestingLevel;
        blockTabRec.parentBlockNo = this.currentNestingLevel > 0 ? this.openBlocksTab[this.currentNestingLevel - 1] : -1;
        blockTabRec.definitionIsOpen = true;
        blockTabRec.blockVarCnt = 0;
        blockTabRec.firstVarRefNo = -1;
        blockTabRec.blockVarNoToVarNoMap = new int[32];
        blockTabRec.dummy = false;
        if (string != null) {
            this.blockNameToNoMap.put(string.toUpperCase(), new Integer(n2));
        }
        return n2;
    }

    private void excludeTemplateRange(int n2, int n3) {
        if (this.blockTabCnt > 0) {
            BlockTabRec blockTabRec = this.blockTab[this.blockTabCnt - 1];
            if (blockTabRec.dummy && blockTabRec.tPosEnd == n2) {
                blockTabRec.tPosContentsEnd = n3;
                blockTabRec.tPosEnd = n3;
                return;
            }
        }
        int n4 = this.registerBlock(null);
        BlockTabRec blockTabRec = this.blockTab[n4];
        blockTabRec.tPosBegin = n2;
        blockTabRec.tPosContentsBegin = n2;
        blockTabRec.tPosContentsEnd = n3;
        blockTabRec.tPosEnd = n3;
        blockTabRec.definitionIsOpen = false;
        blockTabRec.dummy = true;
    }

    private void checkBlockDefinitionsComplete() throws MiniTemplator.TemplateSyntaxException {
        for (int i2 = 0; i2 < this.blockTabCnt; ++i2) {
            BlockTabRec blockTabRec = this.blockTab[i2];
            if (!blockTabRec.definitionIsOpen) continue;
            throw new MiniTemplator.TemplateSyntaxException("Missing $EndBlock command in template for block \"" + blockTabRec.blockName + "\".");
        }
        if (this.currentNestingLevel != 0) {
            throw new MiniTemplator.TemplateSyntaxException("Block nesting level error at end of template.");
        }
    }

    private void processIncludeCmd(String string, int n2, int n3) throws MiniTemplator.TemplateSyntaxException {
        int n4;
        if (this.conditionalExclude(n2, n3)) {
            return;
        }
        int n5 = MiniTemplatorParser.skipBlanks(string, 0);
        if (n5 >= string.length()) {
            throw new MiniTemplator.TemplateSyntaxException("Missing subtemplate name in $Include command in template at offset " + n2 + ".");
        }
        if (string.charAt(n5) == '\"') {
            if ((n4 = string.indexOf(34, ++n5)) == -1) {
                throw new MiniTemplator.TemplateSyntaxException("Missing closing quote for subtemplate name in $Include command in template at offset " + n2 + ".");
            }
        } else {
            n4 = MiniTemplatorParser.skipNonBlanks(string, n5);
        }
        String string2 = string.substring(n5, n4);
        if (!MiniTemplatorParser.isRestOfStringBlank(string, ++n4)) {
            throw new MiniTemplator.TemplateSyntaxException("Extra parameter in $Include command in template at offset " + n2 + ".");
        }
        this.insertSubtemplate(string2, n2, n3);
    }

    private void insertSubtemplate(String string, int n2, int n3) {
        String string2;
        if (this.templateText.length() > 1000000) {
            throw new RuntimeException("Subtemplate include aborted because the internal template string is longer than 1000000 characters.");
        }
        try {
            string2 = this.miniTemplator.loadSubtemplate(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error while loading subtemplate \"" + string + "\"", iOException);
        }
        StringBuilder stringBuilder = new StringBuilder(this.templateText.length() + string2.length());
        stringBuilder.append(this.templateText, 0, n2);
        stringBuilder.append(string2);
        stringBuilder.append(this.templateText, n3, this.templateText.length());
        this.templateText = stringBuilder.toString();
        this.resumeCmdParsingFromStart = true;
    }

    private boolean isCondEnabled(int n2) {
        if (n2 < 0) {
            return true;
        }
        return this.condEnabled[n2];
    }

    private boolean conditionalExclude(int n2, int n3) {
        if (this.isCondEnabled(this.condLevel)) {
            return false;
        }
        this.excludeTemplateRange(n2, n3);
        return true;
    }

    private boolean evaluateConditionFlags(String string) {
        if (this.conditionFlags == null) {
            return false;
        }
        int n2 = 0;
        while ((n2 = MiniTemplatorParser.skipBlanks(string, n2)) < string.length()) {
            boolean bl = false;
            if (string.charAt(n2) == '!') {
                bl = true;
                ++n2;
            }
            if ((n2 = MiniTemplatorParser.skipBlanks(string, n2)) >= string.length()) break;
            int n3 = n2;
            String string2 = string.substring(n3, n2 = MiniTemplatorParser.skipNonBlanks(string, n3 + 1)).toUpperCase();
            if (!(this.conditionFlags.contains(string2) ^ bl)) continue;
            return true;
        }
        return false;
    }

    private void processIfCmd(String string, int n2, int n3) throws MiniTemplator.TemplateSyntaxException {
        boolean bl;
        this.excludeTemplateRange(n2, n3);
        if (this.condLevel >= 19) {
            throw new MiniTemplator.TemplateSyntaxException("Too many nested $if commands.");
        }
        ++this.condLevel;
        this.condEnabled[this.condLevel] = bl = this.isCondEnabled(this.condLevel - 1) && this.evaluateConditionFlags(string);
        this.condPassed[this.condLevel] = bl;
    }

    private void processElseIfCmd(String string, int n2, int n3) throws MiniTemplator.TemplateSyntaxException {
        boolean bl;
        this.excludeTemplateRange(n2, n3);
        if (this.condLevel < 0) {
            throw new MiniTemplator.TemplateSyntaxException("$elseIf without matching $if.");
        }
        this.condEnabled[this.condLevel] = bl = this.isCondEnabled(this.condLevel - 1) && !this.condPassed[this.condLevel] && this.evaluateConditionFlags(string);
        if (bl) {
            this.condPassed[this.condLevel] = true;
        }
    }

    private void processElseCmd(String string, int n2, int n3) throws MiniTemplator.TemplateSyntaxException {
        boolean bl;
        this.excludeTemplateRange(n2, n3);
        if (string.trim().length() != 0) {
            throw new MiniTemplator.TemplateSyntaxException("Invalid parameters for $else command.");
        }
        if (this.condLevel < 0) {
            throw new MiniTemplator.TemplateSyntaxException("$else without matching $if.");
        }
        this.condEnabled[this.condLevel] = bl = this.isCondEnabled(this.condLevel - 1) && !this.condPassed[this.condLevel];
        if (bl) {
            this.condPassed[this.condLevel] = true;
        }
    }

    private void processEndIfCmd(String string, int n2, int n3) throws MiniTemplator.TemplateSyntaxException {
        this.excludeTemplateRange(n2, n3);
        if (string.trim().length() != 0) {
            throw new MiniTemplator.TemplateSyntaxException("Invalid parameters for $endIf command.");
        }
        if (this.condLevel < 0) {
            throw new MiniTemplator.TemplateSyntaxException("$endif without matching $if.");
        }
        --this.condLevel;
    }

    private void associateVariablesWithBlocks() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n2 < this.varRefTabCnt) {
            int n5;
            VarRefTabRec varRefTabRec = this.varRefTab[n2];
            int n6 = varRefTabRec.tPosBegin;
            int n7 = varRefTabRec.varNo;
            if (n6 >= this.blockTab[n3].tPosEnd) {
                n3 = this.blockTab[n3].parentBlockNo;
                continue;
            }
            if (n4 < this.blockTabCnt && n6 >= this.blockTab[n4].tPosBegin) {
                n3 = n4++;
                continue;
            }
            BlockTabRec blockTabRec = this.blockTab[n3];
            if (n6 < blockTabRec.tPosBegin) {
                throw new Error();
            }
            ++blockTabRec.blockVarCnt;
            if (blockTabRec.blockVarCnt > blockTabRec.blockVarNoToVarNoMap.length) {
                blockTabRec.blockVarNoToVarNoMap = (int[])MiniTemplatorParser.resizeArray(blockTabRec.blockVarNoToVarNoMap, 2 * blockTabRec.blockVarCnt);
            }
            blockTabRec.blockVarNoToVarNoMap[n5] = n7;
            if (blockTabRec.firstVarRefNo == -1) {
                blockTabRec.firstVarRefNo = n2;
            }
            varRefTabRec.blockNo = n3;
            varRefTabRec.blockVarNo = n5;
            ++n2;
        }
    }

    private void parseTemplateVariables() throws MiniTemplator.TemplateSyntaxException {
        int n2 = 0;
        while ((n2 = this.templateText.indexOf("${", n2)) != -1) {
            String string;
            int n3 = n2;
            if ((n2 = this.templateText.indexOf("}", n2)) == -1) {
                throw new MiniTemplator.TemplateSyntaxException("Invalid variable reference in template at offset " + n3 + ".");
            }
            if ((string = this.templateText.substring(n3 + 2, ++n2 - 1).trim()).length() == 0) {
                throw new MiniTemplator.TemplateSyntaxException("Empty variable name in template at offset " + n3 + ".");
            }
            this.registerVariableReference(string, n3, n2);
        }
    }

    private void registerVariableReference(String string, int n2, int n3) {
        VarRefTabRec varRefTabRec;
        int n4 = this.lookupVariableName(string);
        if (n4 == -1) {
            n4 = this.registerVariable(string);
        }
        int n5 = this.varRefTabCnt++;
        if (this.varRefTabCnt > this.varRefTab.length) {
            this.varRefTab = (VarRefTabRec[])MiniTemplatorParser.resizeArray(this.varRefTab, 2 * this.varRefTabCnt);
        }
        this.varRefTab[n5] = varRefTabRec = new VarRefTabRec();
        varRefTabRec.tPosBegin = n2;
        varRefTabRec.tPosEnd = n3;
        varRefTabRec.varNo = n4;
    }

    private int registerVariable(String string) {
        int n2 = this.varTabCnt++;
        if (this.varTabCnt > this.varTab.length) {
            this.varTab = (String[])MiniTemplatorParser.resizeArray(this.varTab, 2 * this.varTabCnt);
        }
        this.varTab[n2] = string;
        this.varNameToNoMap.put(string.toUpperCase(), new Integer(n2));
        return n2;
    }

    public int lookupVariableName(String string) {
        Integer n2 = this.varNameToNoMap.get(string.toUpperCase());
        if (n2 == null) {
            return -1;
        }
        int n3 = n2;
        return n3;
    }

    public int lookupBlockName(String string) {
        Integer n2 = this.blockNameToNoMap.get(string.toUpperCase());
        if (n2 == null) {
            return -1;
        }
        int n3 = n2;
        return n3;
    }

    public static Object resizeArray(Object object, int n2) {
        int n3 = Array.getLength(object);
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n2);
        int n4 = Math.min(n3, n2);
        if (n4 > 0) {
            System.arraycopy(object, 0, object2, 0, n4);
        }
        return object2;
    }

    private static int skipBlanks(String string, int n2) {
        while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    private static int skipNonBlanks(String string, int n2) {
        while (n2 < string.length() && !Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    public static boolean isRestOfStringBlank(String string, int n2) {
        return MiniTemplatorParser.skipBlanks(string, n2) >= string.length();
    }

    public static class BlockTabRec {
        String blockName;
        int nextWithSameName;
        int tPosBegin;
        int tPosContentsBegin;
        int tPosContentsEnd;
        int tPosEnd;
        int nestingLevel;
        int parentBlockNo;
        boolean definitionIsOpen;
        int blockVarCnt;
        int[] blockVarNoToVarNoMap;
        int firstVarRefNo;
        boolean dummy;
    }

    public static class VarRefTabRec {
        int varNo;
        int tPosBegin;
        int tPosEnd;
        int blockNo;
        int blockVarNo;
    }
}

