/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamExceptionHandler;
import com.github.sarxos.webcam.WebcamMotionEvent;
import com.github.sarxos.webcam.WebcamMotionListener;
import com.github.sarxos.webcam.util.jh.JHBlurFilter;
import com.github.sarxos.webcam.util.jh.JHGrayFilter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamMotionDetector {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamMotionDetector.class);
    public static final int DEFAULT_THREASHOLD = 25;
    private List<WebcamMotionListener> listeners = new ArrayList<WebcamMotionListener>();
    private Object mutex = new Object();
    private boolean running = false;
    private boolean motion = false;
    private BufferedImage previous = null;
    private Webcam webcam = null;
    private int interval = 1000;
    private int threshold = 10;
    private int inertia = 10000;
    private int strength = 0;
    private JHBlurFilter blur = new JHBlurFilter(3.0f, 3.0f, 1);
    private JHGrayFilter gray = new JHGrayFilter();
    private ThreadFactory threadFactory = new DetectorThreadFactory();
    private ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);

    public WebcamMotionDetector(Webcam webcam, int threshold, int inertia) {
        this.webcam = webcam;
        this.threshold = threshold;
        this.inertia = inertia;
    }

    public WebcamMotionDetector(Webcam webcam, int threshold) {
        this(webcam, threshold, 0);
    }

    public WebcamMotionDetector(Webcam webcam) {
        this(webcam, 25, 0);
    }

    public void start() {
        if (!this.webcam.isOpen()) {
            this.webcam.open();
        }
        LOG.debug("Starting motion detector");
        this.executor.submit(new Runner());
    }

    public void stop() {
        this.running = false;
        if (this.webcam.isOpen()) {
            this.webcam.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(WebcamMotionDetector.class.getSimpleName() + ".detect()");
        }
        if (this.motion) {
            LOG.debug("Motion detector still in inertia state, no need to check");
            return;
        }
        BufferedImage current = this.webcam.getImage();
        current = this.blur.filter(current, null);
        current = this.gray.filter(current, null);
        if (this.previous != null) {
            int w2 = current.getWidth();
            int h2 = current.getHeight();
            int strength = 0;
            Object object = this.mutex;
            synchronized (object) {
                for (int i2 = 0; i2 < w2; ++i2) {
                    for (int j2 = 0; j2 < h2; ++j2) {
                        int c2 = current.getRGB(i2, j2);
                        int p2 = this.previous.getRGB(i2, j2);
                        int rgb = WebcamMotionDetector.combinePixels(c2, p2);
                        int cr = (rgb & 0xFF0000) >> 16;
                        int cg = (rgb & 0xFF00) >> 8;
                        int cb = rgb & 0xFF;
                        int max = Math.max(Math.max(cr, cg), cb);
                        if (max <= this.threshold) continue;
                        if (!this.motion) {
                            this.executor.submit(new Changer());
                            this.motion = true;
                        }
                        ++strength;
                    }
                }
                this.strength = strength;
                if (this.motion) {
                    this.notifyMotionListeners();
                }
            }
        }
        this.previous = current;
    }

    private void notifyMotionListeners() {
        WebcamMotionEvent wme = new WebcamMotionEvent(this, this.strength);
        for (WebcamMotionListener l2 : this.listeners) {
            try {
                l2.motionDetected(wme);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public boolean addMotionListener(WebcamMotionListener l2) {
        return this.listeners.add(l2);
    }

    public WebcamMotionListener[] getMotionListeners() {
        return this.listeners.toArray(new WebcamMotionListener[this.listeners.size()]);
    }

    public boolean removeMotionListener(WebcamMotionListener l2) {
        return this.listeners.remove(l2);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public Webcam getWebcam() {
        return this.webcam;
    }

    public boolean isMotion() {
        if (!this.running) {
            LOG.warn("Motion cannot be detected when detector is not running!");
        }
        return this.motion;
    }

    public int getMotionStrength() {
        return this.strength;
    }

    private static int combinePixels(int rgb1, int rgb2) {
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int a2 = rgb2 >> 24 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        r1 = WebcamMotionDetector.clamp(Math.abs(r1 - r2));
        g1 = WebcamMotionDetector.clamp(Math.abs(g1 - g2));
        b1 = WebcamMotionDetector.clamp(Math.abs(b1 - b2));
        if (a1 != 255) {
            a1 = a1 * 255 / 255;
            int a3 = (255 - a1) * a2 / 255;
            r1 = WebcamMotionDetector.clamp((r1 * a1 + r2 * a3) / 255);
            g1 = WebcamMotionDetector.clamp((g1 * a1 + g2 * a3) / 255);
            b1 = WebcamMotionDetector.clamp((b1 * a1 + b2 * a3) / 255);
            a1 = WebcamMotionDetector.clamp(a1 + a3);
        }
        return a1 << 24 | r1 << 16 | g1 << 8 | b1;
    }

    private static int clamp(int c2) {
        if (c2 < 0) {
            return 0;
        }
        if (c2 > 255) {
            return 255;
        }
        return c2;
    }

    private class Changer
    implements Runnable {
        private Changer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int time = WebcamMotionDetector.this.inertia == 0 ? WebcamMotionDetector.this.interval + WebcamMotionDetector.this.interval / 2 : WebcamMotionDetector.this.inertia;
            LOG.debug("Motion change has been sheduled in " + time + "ms");
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e2) {
                throw new RuntimeException(e2);
            }
            Object object = WebcamMotionDetector.this.mutex;
            synchronized (object) {
                WebcamMotionDetector.this.motion = false;
            }
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            WebcamMotionDetector.this.running = true;
            while (WebcamMotionDetector.this.running && WebcamMotionDetector.this.webcam.isOpen()) {
                WebcamMotionDetector.this.detect();
                try {
                    Thread.sleep(WebcamMotionDetector.this.interval);
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    private static final class DetectorThreadFactory
    implements ThreadFactory {
        private static int number = 0;

        private DetectorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t2 = new Thread(runnable, "motion-detector-" + ++number);
            t2.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
            t2.setDaemon(true);
            return t2;
        }
    }
}

