/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGFPoly;

public final class GenericGF {
    public static final GenericGF AZTEC_DATA_12 = new GenericGF(4201, 4096, 1);
    public static final GenericGF AZTEC_DATA_10 = new GenericGF(1033, 1024, 1);
    public static final GenericGF AZTEC_DATA_6 = new GenericGF(67, 64, 1);
    public static final GenericGF AZTEC_PARAM = new GenericGF(19, 16, 1);
    public static final GenericGF QR_CODE_FIELD_256 = new GenericGF(285, 256, 0);
    public static final GenericGF DATA_MATRIX_FIELD_256;
    public static final GenericGF AZTEC_DATA_8;
    public static final GenericGF MAXICODE_FIELD_64;
    private static final int INITIALIZATION_THRESHOLD = 0;
    private int[] expTable;
    private int[] logTable;
    private GenericGFPoly zero;
    private GenericGFPoly one;
    private final int size;
    private final int primitive;
    private final int generatorBase;
    private boolean initialized = false;

    public GenericGF(int primitive, int size, int b2) {
        this.primitive = primitive;
        this.size = size;
        this.generatorBase = b2;
        if (size <= 0) {
            this.initialize();
        }
    }

    private void initialize() {
        int i2;
        this.expTable = new int[this.size];
        this.logTable = new int[this.size];
        int x2 = 1;
        for (i2 = 0; i2 < this.size; ++i2) {
            this.expTable[i2] = x2;
            if ((x2 <<= 1) < this.size) continue;
            x2 ^= this.primitive;
            x2 &= this.size - 1;
        }
        for (i2 = 0; i2 < this.size - 1; ++i2) {
            this.logTable[this.expTable[i2]] = i2;
        }
        this.zero = new GenericGFPoly(this, new int[]{0});
        this.one = new GenericGFPoly(this, new int[]{1});
        this.initialized = true;
    }

    private void checkInit() {
        if (!this.initialized) {
            this.initialize();
        }
    }

    GenericGFPoly getZero() {
        this.checkInit();
        return this.zero;
    }

    GenericGFPoly getOne() {
        this.checkInit();
        return this.one;
    }

    GenericGFPoly buildMonomial(int degree, int coefficient) {
        this.checkInit();
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.zero;
        }
        int[] coefficients = new int[degree + 1];
        coefficients[0] = coefficient;
        return new GenericGFPoly(this, coefficients);
    }

    static int addOrSubtract(int a2, int b2) {
        return a2 ^ b2;
    }

    int exp(int a2) {
        this.checkInit();
        return this.expTable[a2];
    }

    int log(int a2) {
        this.checkInit();
        if (a2 == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[a2];
    }

    int inverse(int a2) {
        this.checkInit();
        if (a2 == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[this.size - this.logTable[a2] - 1];
    }

    int multiply(int a2, int b2) {
        this.checkInit();
        if (a2 == 0 || b2 == 0) {
            return 0;
        }
        return this.expTable[(this.logTable[a2] + this.logTable[b2]) % (this.size - 1)];
    }

    public int getSize() {
        return this.size;
    }

    public int getGeneratorBase() {
        return this.generatorBase;
    }

    public String toString() {
        return "GF(0x" + Integer.toHexString(this.primitive) + ',' + this.size + ')';
    }

    static {
        AZTEC_DATA_8 = DATA_MATRIX_FIELD_256 = new GenericGF(301, 256, 1);
        MAXICODE_FIELD_64 = AZTEC_DATA_6;
    }
}

