/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.ResultPoint;

public final class FinderPattern
extends ResultPoint {
    private final float estimatedModuleSize;
    private final int count;

    FinderPattern(float posX, float posY, float estimatedModuleSize) {
        this(posX, posY, estimatedModuleSize, 1);
    }

    private FinderPattern(float posX, float posY, float estimatedModuleSize, int count) {
        super(posX, posY);
        this.estimatedModuleSize = estimatedModuleSize;
        this.count = count;
    }

    public float getEstimatedModuleSize() {
        return this.estimatedModuleSize;
    }

    int getCount() {
        return this.count;
    }

    boolean aboutEquals(float moduleSize, float i2, float j2) {
        if (Math.abs(i2 - this.getY()) <= moduleSize && Math.abs(j2 - this.getX()) <= moduleSize) {
            float moduleSizeDiff = Math.abs(moduleSize - this.estimatedModuleSize);
            return moduleSizeDiff <= 1.0f || moduleSizeDiff <= this.estimatedModuleSize;
        }
        return false;
    }

    FinderPattern combineEstimate(float i2, float j2, float newModuleSize) {
        int combinedCount = this.count + 1;
        float combinedX = ((float)this.count * this.getX() + j2) / (float)combinedCount;
        float combinedY = ((float)this.count * this.getY() + i2) / (float)combinedCount;
        float combinedModuleSize = ((float)this.count * this.estimatedModuleSize + newModuleSize) / (float)combinedCount;
        return new FinderPattern(combinedX, combinedY, combinedModuleSize, combinedCount);
    }
}

