/*
 * Decompiled with CFR 0.152.
 */
package biz.source_code.miniTemplator;

import biz.source_code.miniTemplator.MiniTemplatorParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniTemplator {
    private MiniTemplatorParser mtp;
    private Charset charset;
    private String subtemplateBasePath;
    private String[] varValuesTab;
    private BlockDynTabRec[] blockDynTab;
    private BlockInstTabRec[] blockInstTab;
    private int blockInstTabCnt;

    public MiniTemplator(TemplateSpecification templateSpecification) throws IOException, TemplateSyntaxException {
        this.init(templateSpecification);
    }

    public MiniTemplator(String string) throws IOException, TemplateSyntaxException {
        TemplateSpecification templateSpecification = new TemplateSpecification();
        templateSpecification.templateFileName = string;
        this.init(templateSpecification);
    }

    private void init(TemplateSpecification templateSpecification) throws IOException, TemplateSyntaxException {
        String string;
        this.charset = templateSpecification.charset;
        if (this.charset == null) {
            this.charset = Charset.defaultCharset();
        }
        this.subtemplateBasePath = templateSpecification.subtemplateBasePath;
        if (this.subtemplateBasePath == null && templateSpecification.templateFileName != null) {
            this.subtemplateBasePath = new File(templateSpecification.templateFileName).getParent();
        }
        if ((string = templateSpecification.templateText) == null && templateSpecification.templateFileName != null) {
            string = this.readFileIntoString(templateSpecification.templateFileName);
        }
        if (string == null) {
            throw new IllegalArgumentException("No templateFileName or templateText specified.");
        }
        this.mtp = new MiniTemplatorParser(string, templateSpecification.conditionFlags, this);
        this.reset();
    }

    private MiniTemplator() {
    }

    protected String loadSubtemplate(String string) throws IOException {
        String string2 = new File(this.subtemplateBasePath, string).getPath();
        return this.readFileIntoString(string2);
    }

    public void reset() {
        int n2;
        if (this.varValuesTab == null) {
            this.varValuesTab = new String[this.mtp.varTabCnt];
        } else {
            for (n2 = 0; n2 < this.mtp.varTabCnt; ++n2) {
                this.varValuesTab[n2] = null;
            }
        }
        if (this.blockDynTab == null) {
            this.blockDynTab = new BlockDynTabRec[this.mtp.blockTabCnt];
        }
        for (n2 = 0; n2 < this.mtp.blockTabCnt; ++n2) {
            BlockDynTabRec blockDynTabRec = this.blockDynTab[n2];
            if (blockDynTabRec == null) {
                this.blockDynTab[n2] = blockDynTabRec = new BlockDynTabRec();
            }
            blockDynTabRec.instances = 0;
            blockDynTabRec.firstBlockInstNo = -1;
            blockDynTabRec.lastBlockInstNo = -1;
        }
        this.blockInstTabCnt = 0;
    }

    public MiniTemplator cloneReset() {
        MiniTemplator miniTemplator = new MiniTemplator();
        miniTemplator.mtp = this.mtp;
        miniTemplator.charset = this.charset;
        miniTemplator.reset();
        return miniTemplator;
    }

    public void setVariable(String string, String string2, boolean bl) throws VariableNotDefinedException {
        int n2 = this.mtp.lookupVariableName(string);
        if (n2 == -1) {
            if (bl) {
                return;
            }
            throw new VariableNotDefinedException(string);
        }
        this.varValuesTab[n2] = string2;
    }

    public void setVariable(String string, String string2) throws VariableNotDefinedException {
        this.setVariable(string, string2, false);
    }

    public void setVariableOpt(String string, String string2) {
        this.setVariable(string, string2, true);
    }

    public void setVariableEsc(String string, String string2, boolean bl) throws VariableNotDefinedException {
        this.setVariable(string, MiniTemplator.escapeHtml(string2), bl);
    }

    public void setVariableEsc(String string, String string2) throws VariableNotDefinedException {
        this.setVariable(string, MiniTemplator.escapeHtml(string2), false);
    }

    public void setVariableOptEsc(String string, String string2) {
        this.setVariable(string, MiniTemplator.escapeHtml(string2), true);
    }

    public boolean variableExists(String string) {
        return this.mtp.lookupVariableName(string) != -1;
    }

    public Map<String, String> getVariables() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.mtp.varTabCnt);
        for (int i2 = 0; i2 < this.mtp.varTabCnt; ++i2) {
            hashMap.put(this.mtp.varTab[i2], this.varValuesTab[i2]);
        }
        return hashMap;
    }

    public void addBlock(String string, boolean bl) throws BlockNotDefinedException {
        int n2 = this.mtp.lookupBlockName(string);
        if (n2 == -1) {
            if (bl) {
                return;
            }
            throw new BlockNotDefinedException(string);
        }
        while (n2 != -1) {
            this.addBlockByNo(n2);
            n2 = this.mtp.blockTab[n2].nextWithSameName;
        }
    }

    public void addBlock(String string) throws BlockNotDefinedException {
        this.addBlock(string, false);
    }

    public void addBlockOpt(String string) {
        this.addBlock(string, true);
    }

    private void addBlockByNo(int n2) {
        MiniTemplatorParser.BlockTabRec blockTabRec = this.mtp.blockTab[n2];
        BlockDynTabRec blockDynTabRec = this.blockDynTab[n2];
        int n3 = this.registerBlockInstance();
        BlockInstTabRec blockInstTabRec = this.blockInstTab[n3];
        if (blockDynTabRec.firstBlockInstNo == -1) {
            blockDynTabRec.firstBlockInstNo = n3;
        }
        if (blockDynTabRec.lastBlockInstNo != -1) {
            this.blockInstTab[blockDynTabRec.lastBlockInstNo].nextBlockInstNo = n3;
        }
        blockDynTabRec.lastBlockInstNo = n3;
        blockInstTabRec.blockNo = n2;
        blockInstTabRec.instanceLevel = blockDynTabRec.instances++;
        blockInstTabRec.parentInstLevel = blockTabRec.parentBlockNo == -1 ? -1 : this.blockDynTab[blockTabRec.parentBlockNo].instances;
        blockInstTabRec.nextBlockInstNo = -1;
        if (blockTabRec.blockVarCnt > 0) {
            blockInstTabRec.blockVarTab = new String[blockTabRec.blockVarCnt];
        }
        for (int i2 = 0; i2 < blockTabRec.blockVarCnt; ++i2) {
            int n4 = blockTabRec.blockVarNoToVarNoMap[i2];
            blockInstTabRec.blockVarTab[i2] = this.varValuesTab[n4];
        }
    }

    private int registerBlockInstance() {
        int n2 = this.blockInstTabCnt++;
        if (this.blockInstTab == null) {
            this.blockInstTab = new BlockInstTabRec[64];
        }
        if (this.blockInstTabCnt > this.blockInstTab.length) {
            this.blockInstTab = (BlockInstTabRec[])MiniTemplatorParser.resizeArray(this.blockInstTab, 2 * this.blockInstTabCnt);
        }
        this.blockInstTab[n2] = new BlockInstTabRec();
        return n2;
    }

    public boolean blockExists(String string) {
        return this.mtp.lookupBlockName(string) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOutput(String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.charset);
            this.generateOutput(outputStreamWriter);
        }
        finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public void generateOutput(Writer writer) throws IOException {
        String string = this.generateOutput();
        writer.write(string);
    }

    public String generateOutput() {
        if (this.blockDynTab[0].instances == 0) {
            this.addBlockByNo(0);
        }
        for (int i2 = 0; i2 < this.mtp.blockTabCnt; ++i2) {
            BlockDynTabRec blockDynTabRec = this.blockDynTab[i2];
            blockDynTabRec.currBlockInstNo = blockDynTabRec.firstBlockInstNo;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.writeBlockInstances(stringBuilder, 0, -1);
        return stringBuilder.toString();
    }

    private void writeBlockInstances(StringBuilder stringBuilder, int n2, int n3) {
        int n4;
        BlockDynTabRec blockDynTabRec = this.blockDynTab[n2];
        while ((n4 = blockDynTabRec.currBlockInstNo) != -1) {
            BlockInstTabRec blockInstTabRec = this.blockInstTab[n4];
            if (blockInstTabRec.parentInstLevel < n3) {
                throw new Error();
            }
            if (blockInstTabRec.parentInstLevel > n3) break;
            this.writeBlockInstance(stringBuilder, n4);
            blockDynTabRec.currBlockInstNo = blockInstTabRec.nextBlockInstNo;
        }
    }

    private void writeBlockInstance(StringBuilder stringBuilder, int n2) {
        BlockInstTabRec blockInstTabRec = this.blockInstTab[n2];
        int n3 = blockInstTabRec.blockNo;
        MiniTemplatorParser.BlockTabRec blockTabRec = this.mtp.blockTab[n3];
        int n4 = blockTabRec.tPosContentsBegin;
        int n5 = n3 + 1;
        int n6 = blockTabRec.firstVarRefNo;
        while (true) {
            Object object;
            int n7 = blockTabRec.tPosContentsEnd;
            int n8 = 0;
            if (n6 != -1 && n6 < this.mtp.varRefTabCnt) {
                object = this.mtp.varRefTab[n6];
                if (((MiniTemplatorParser.VarRefTabRec)object).tPosBegin < n4) {
                    ++n6;
                    continue;
                }
                if (((MiniTemplatorParser.VarRefTabRec)object).tPosBegin < n7) {
                    n7 = ((MiniTemplatorParser.VarRefTabRec)object).tPosBegin;
                    n8 = 1;
                }
            }
            if (n5 < this.mtp.blockTabCnt) {
                object = this.mtp.blockTab[n5];
                if (((MiniTemplatorParser.BlockTabRec)object).tPosBegin < n4) {
                    ++n5;
                    continue;
                }
                if (((MiniTemplatorParser.BlockTabRec)object).tPosBegin < n7) {
                    n7 = ((MiniTemplatorParser.BlockTabRec)object).tPosBegin;
                    n8 = 2;
                }
            }
            if (n7 > n4) {
                stringBuilder.append(this.mtp.templateText.substring(n4, n7));
            }
            switch (n8) {
                case 0: {
                    return;
                }
                case 1: {
                    object = this.mtp.varRefTab[n6];
                    if (((MiniTemplatorParser.VarRefTabRec)object).blockNo != n3) {
                        throw new Error();
                    }
                    String string = blockInstTabRec.blockVarTab[((MiniTemplatorParser.VarRefTabRec)object).blockVarNo];
                    if (string != null) {
                        stringBuilder.append(string);
                    }
                    n4 = ((MiniTemplatorParser.VarRefTabRec)object).tPosEnd;
                    ++n6;
                    break;
                }
                case 2: {
                    object = this.mtp.blockTab[n5];
                    if (((MiniTemplatorParser.BlockTabRec)object).parentBlockNo != n3) {
                        throw new Error();
                    }
                    this.writeBlockInstances(stringBuilder, n5, blockInstTabRec.instanceLevel);
                    n4 = ((MiniTemplatorParser.BlockTabRec)object).tPosEnd;
                    ++n5;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileIntoString(String string) throws IOException {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.charset);
            String string2 = MiniTemplator.readStreamIntoString(inputStreamReader);
            return string2;
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private static String readStreamIntoString(Reader reader) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[65536];
        while ((n2 = reader.read(cArray)) != -1) {
            if (n2 <= 0) {
                throw new IOException();
            }
            stringBuilder.append(cArray, 0, n2);
        }
        return stringBuilder.toString();
    }

    public static String escapeHtml(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        boolean bl = false;
        block10: for (n2 = 0; n2 < n3; ++n2) {
            switch (string.charAt(n2)) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    bl = true;
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        if (!bl) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n3 + 16);
        stringBuilder.append(string.substring(0, n2));
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '<': {
                    stringBuilder.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    break;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    break;
                }
                case '\"': {
                    stringBuilder.append("&#34;");
                    break;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static class BlockInstTabRec {
        int blockNo;
        int instanceLevel;
        int parentInstLevel;
        int nextBlockInstNo;
        String[] blockVarTab;

        private BlockInstTabRec() {
        }
    }

    private static class BlockDynTabRec {
        int instances;
        int firstBlockInstNo;
        int lastBlockInstNo;
        int currBlockInstNo;

        private BlockDynTabRec() {
        }
    }

    public static class TemplateSpecification {
        public String templateFileName;
        public String subtemplateBasePath;
        public Charset charset;
        public String templateText;
        public Set<String> conditionFlags;
    }

    public static class BlockNotDefinedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BlockNotDefinedException(String string) {
            super("Block \"" + string + "\" not defined in template.");
        }
    }

    public static class VariableNotDefinedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VariableNotDefinedException(String string) {
            super("Variable \"" + string + "\" not defined in template.");
        }
    }

    public static class TemplateSyntaxException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TemplateSyntaxException(String string) {
            super("Syntax error in template: " + string);
        }
    }
}

