/*
 * Decompiled with CFR 0.152.
 */
package biz.source_code.miniTemplator;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.IOException;
import java.util.HashMap;

public class MiniTemplatorCache {
    private HashMap<String, MiniTemplator> cache = new HashMap();

    public synchronized MiniTemplator get(MiniTemplator.TemplateSpecification templateSpecification) throws IOException, MiniTemplator.TemplateSyntaxException {
        String string = MiniTemplatorCache.generateCacheKey(templateSpecification);
        MiniTemplator miniTemplator = this.cache.get(string);
        if (miniTemplator == null) {
            miniTemplator = new MiniTemplator(templateSpecification);
            this.cache.put(string, miniTemplator);
        }
        return miniTemplator.cloneReset();
    }

    private static String generateCacheKey(MiniTemplator.TemplateSpecification templateSpecification) {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (templateSpecification.templateText != null) {
            stringBuilder.append(templateSpecification.templateText);
        } else if (templateSpecification.templateFileName != null) {
            stringBuilder.append(templateSpecification.templateFileName);
        } else {
            throw new IllegalArgumentException("No templateFileName or templateText specified.");
        }
        if (templateSpecification.conditionFlags != null) {
            for (String string : templateSpecification.conditionFlags) {
                stringBuilder.append('|');
                stringBuilder.append(string.toUpperCase());
            }
        }
        return stringBuilder.toString();
    }

    public synchronized void clear() {
        this.cache.clear();
    }
}

