/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamExceptionHandler;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamPanel
extends JPanel
implements WebcamListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WebcamPanel.class);
    public static final double MIN_FREQUENCY = 0.016;
    private static final double MAX_FREQUENCY = 50.0;
    private static final ThreadFactory THREAD_FACTORY = new PanelThreadFactory();
    private ScheduledExecutorService executor = null;
    private ResourceBundle rb = null;
    private boolean fillArea = false;
    private double frequency = 5.0;
    private boolean frequencyLimit = false;
    private boolean frequencyDisplayed = false;
    private Webcam webcam = null;
    private BufferedImage image = null;
    private volatile ImageUpdater updater = null;
    private volatile boolean starting = false;
    private volatile boolean paused = false;
    private volatile boolean errored = false;
    private AtomicBoolean started = new AtomicBoolean(false);
    private Painter defaultPainter;
    private Painter painter = this.defaultPainter = new DefaultPainter();
    private Dimension size = null;

    public WebcamPanel(Webcam webcam) {
        this(webcam, true);
    }

    public WebcamPanel(Webcam webcam, boolean start) {
        this(webcam, null, start);
    }

    public WebcamPanel(Webcam webcam, Dimension size, boolean start) {
        if (webcam == null) {
            throw new IllegalArgumentException(String.format("Webcam argument in %s constructor cannot be null!", this.getClass().getSimpleName()));
        }
        this.size = size;
        this.webcam = webcam;
        this.webcam.addWebcamListener(this);
        this.rb = WebcamUtils.loadRB(WebcamPanel.class, this.getLocale());
        this.addPropertyChangeListener("locale", this);
        if (size == null) {
            Dimension r2 = webcam.getViewSize();
            if (r2 == null) {
                r2 = webcam.getViewSizes()[0];
            }
            this.setPreferredSize(r2);
        } else {
            this.setPreferredSize(size);
        }
        if (start) {
            this.start();
        }
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public Painter getPainter() {
        return this.painter;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (this.image == null) {
            this.painter.paintPanel(this, g22);
        } else {
            this.painter.paintImage(this, this.image, g22);
        }
    }

    @Override
    public void webcamOpen(WebcamEvent we) {
        if (this.updater == null) {
            this.updater = new ImageUpdater();
            this.updater.start();
        }
        if (this.size == null) {
            this.setPreferredSize(this.webcam.getViewSize());
        }
    }

    @Override
    public void webcamClosed(WebcamEvent we) {
        this.stop();
    }

    @Override
    public void webcamDisposed(WebcamEvent we) {
        this.webcamClosed(we);
    }

    @Override
    public void webcamImageObtained(WebcamEvent we) {
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        LOG.debug("Starting panel rendering and trying to open attached webcam");
        this.starting = true;
        if (this.updater == null) {
            this.updater = new ImageUpdater();
        }
        this.updater.start();
        try {
            this.errored = !this.webcam.open();
        }
        catch (WebcamException e2) {
            this.errored = true;
            this.repaint();
            throw e2;
        }
        finally {
            this.starting = false;
        }
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        LOG.debug("Stopping panel rendering and closing attached webcam");
        this.updater.stop();
        this.updater = null;
        this.image = null;
        try {
            this.errored = !this.webcam.close();
        }
        catch (WebcamException e2) {
            this.errored = true;
            this.repaint();
            throw e2;
        }
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        LOG.debug("Pausing panel rendering");
        this.paused = true;
    }

    public void resume() {
        if (!this.paused) {
            return;
        }
        LOG.debug("Resuming panel rendering");
        this.paused = false;
    }

    public boolean isFPSLimited() {
        return this.frequencyLimit;
    }

    public void setFPSLimited(boolean frequencyLimit) {
        this.frequencyLimit = frequencyLimit;
    }

    public double getFPSLimit() {
        return this.frequency;
    }

    public void setFPSLimit(double fps) {
        if (fps > 50.0) {
            fps = 50.0;
        }
        if (fps < 0.016) {
            fps = 0.016;
        }
        this.frequency = fps;
    }

    public boolean isFPSDisplayed() {
        return this.frequencyDisplayed;
    }

    public void setFPSDisplayed(boolean displayed) {
        this.frequencyDisplayed = displayed;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void setFillArea(boolean fillArea) {
        this.fillArea = fillArea;
    }

    public boolean isFillArea() {
        return this.fillArea;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Locale lc = (Locale)evt.getNewValue();
        if (lc != null) {
            this.rb = WebcamUtils.loadRB(WebcamPanel.class, lc);
        }
    }

    public Painter getDefaultPainter() {
        return this.defaultPainter;
    }

    private class ImageUpdater
    implements Runnable {
        private Thread scheduler = new RepaintScheduler();
        private AtomicBoolean running = new AtomicBoolean(false);

        private ImageUpdater() {
        }

        public void start() {
            if (this.running.compareAndSet(false, true)) {
                WebcamPanel.this.executor = Executors.newScheduledThreadPool(1, THREAD_FACTORY);
                this.scheduler.start();
            }
        }

        public void stop() {
            if (this.running.compareAndSet(true, false)) {
                WebcamPanel.this.executor.shutdown();
            }
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (Throwable t2) {
                WebcamPanel.this.errored = true;
                WebcamExceptionHandler.handle(t2);
            }
        }

        private void update() {
            if (!this.running.get() || !WebcamPanel.this.webcam.isOpen() || WebcamPanel.this.paused) {
                return;
            }
            BufferedImage tmp = WebcamPanel.this.webcam.getImage();
            if (tmp != null) {
                WebcamPanel.this.errored = false;
                WebcamPanel.this.image = tmp;
            }
            WebcamPanel.this.repaint();
        }

        private class RepaintScheduler
        extends Thread {
            public RepaintScheduler() {
                this.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
                this.setName(String.format("repaint-scheduler-%s", WebcamPanel.this.webcam.getName()));
                this.setDaemon(true);
            }

            @Override
            public void run() {
                if (!ImageUpdater.this.running.get()) {
                    return;
                }
                WebcamPanel.this.repaint();
                while (WebcamPanel.this.starting) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                if (WebcamPanel.this.webcam.isOpen()) {
                    if (WebcamPanel.this.isFPSLimited()) {
                        WebcamPanel.this.executor.scheduleAtFixedRate(WebcamPanel.this.updater, 0L, (long)(1000.0 / WebcamPanel.this.frequency), TimeUnit.MILLISECONDS);
                    } else {
                        WebcamPanel.this.executor.scheduleWithFixedDelay(WebcamPanel.this.updater, 100L, 1L, TimeUnit.MILLISECONDS);
                    }
                } else {
                    WebcamPanel.this.executor.schedule(this, 500L, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private static final class PanelThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger number = new AtomicInteger(0);

        private PanelThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r2) {
            Thread t2 = new Thread(r2, String.format("webcam-panel-scheduled-executor-%d", number.incrementAndGet()));
            t2.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
            t2.setDaemon(true);
            return t2;
        }
    }

    public class DefaultPainter
    implements Painter {
        private String name = null;

        @Override
        public void paintPanel(WebcamPanel owner, Graphics2D g2) {
            assert (owner != null);
            assert (g2 != null);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setBackground(Color.BLACK);
            g2.fillRect(0, 0, WebcamPanel.this.getWidth(), WebcamPanel.this.getHeight());
            int cx = (WebcamPanel.this.getWidth() - 70) / 2;
            int cy = (WebcamPanel.this.getHeight() - 40) / 2;
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRoundRect(cx, cy, 70, 40, 10, 10);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 5, cy + 5, 30, 30);
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillOval(cx + 10, cy + 10, 20, 20);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 12, cy + 12, 16, 16);
            g2.fillRoundRect(cx + 50, cy + 5, 15, 10, 5, 5);
            g2.fillRect(cx + 63, cy + 25, 7, 2);
            g2.fillRect(cx + 63, cy + 28, 7, 2);
            g2.fillRect(cx + 63, cy + 31, 7, 2);
            g2.setColor(Color.DARK_GRAY);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(0, 0, WebcamPanel.this.getWidth(), WebcamPanel.this.getHeight());
            g2.drawLine(0, WebcamPanel.this.getHeight(), WebcamPanel.this.getWidth(), 0);
            String str = null;
            String strInitDevice = WebcamPanel.this.rb.getString("INITIALIZING_DEVICE");
            String strNoImage = WebcamPanel.this.rb.getString("NO_IMAGE");
            String strDeviceError = WebcamPanel.this.rb.getString("DEVICE_ERROR");
            str = !WebcamPanel.this.errored ? (WebcamPanel.this.starting ? strInitDevice : strNoImage) : strDeviceError;
            FontMetrics metrics = g2.getFontMetrics(WebcamPanel.this.getFont());
            int w2 = metrics.stringWidth(str);
            int h2 = metrics.getHeight();
            int x2 = (WebcamPanel.this.getWidth() - w2) / 2;
            int y2 = cy - h2;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setFont(WebcamPanel.this.getFont());
            g2.setColor(Color.WHITE);
            g2.drawString(str, x2, y2);
            if (this.name == null) {
                this.name = WebcamPanel.this.webcam.getName();
            }
            str = this.name;
            w2 = metrics.stringWidth(str);
            h2 = metrics.getHeight();
            g2.drawString(str, (WebcamPanel.this.getWidth() - w2) / 2, cy - 2 * h2);
        }

        @Override
        public void paintImage(WebcamPanel owner, BufferedImage image, Graphics2D g2) {
            int w2 = WebcamPanel.this.getWidth();
            int h2 = WebcamPanel.this.getHeight();
            if (WebcamPanel.this.fillArea && image.getWidth() != w2 && image.getHeight() != h2) {
                BufferedImage resized = new BufferedImage(w2, h2, 5);
                Graphics2D gr = resized.createGraphics();
                gr.setComposite(AlphaComposite.Src);
                gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gr.drawImage(image, 0, 0, w2, h2, null);
                gr.dispose();
                resized.flush();
                image = resized;
            }
            g2.drawImage((Image)image, 0, 0, null);
            if (WebcamPanel.this.isFPSDisplayed()) {
                String str = String.format("FPS: %.1f", WebcamPanel.this.webcam.getFPS());
                int x2 = 5;
                int y2 = WebcamPanel.this.getHeight() - 5;
                g2.setFont(WebcamPanel.this.getFont());
                g2.setColor(Color.BLACK);
                g2.drawString(str, x2 + 1, y2 + 1);
                g2.setColor(Color.WHITE);
                g2.drawString(str, x2, y2);
            }
        }
    }

    public static interface Painter {
        public void paintPanel(WebcamPanel var1, Graphics2D var2);

        public void paintImage(WebcamPanel var1, BufferedImage var2, Graphics2D var3);
    }
}

