/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util;

import com.github.sarxos.webcam.WebcamException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static final String FORMAT_GIF = "GIF";
    public static final String FORMAT_PNG = "PNG";
    public static final String FORMAT_JPG = "JPG";
    public static final String FORMAT_BMP = "BMP";
    public static final String FORMAT_WBMP = "WBMP";

    public static BufferedImage premultiple(BufferedImage src) {
        BufferedImage pre = new BufferedImage(512, 512, 3);
        Graphics2D g2 = pre.createGraphics();
        g2.drawImage((Image)src, 0, 0, null);
        g2.dispose();
        pre.flush();
        return pre;
    }

    public static BufferedImage unpremultiple(BufferedImage pre) {
        BufferedImage src = new BufferedImage(512, 512, 2);
        Graphics2D g2 = pre.createGraphics();
        g2.drawImage((Image)src, 0, 0, null);
        g2.dispose();
        src.flush();
        return src;
    }

    public static byte[] toByteArray(BufferedImage image, String format) {
        byte[] bytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, format, baos);
            bytes = baos.toByteArray();
        }
        catch (IOException e2) {
            throw new WebcamException(e2);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e3) {
                throw new WebcamException(e3);
            }
        }
        return bytes;
    }

    public static byte[] toRawByteArray(BufferedImage image) {
        DataBuffer dbuf = image.getRaster().getDataBuffer();
        if (dbuf instanceof DataBufferByte) {
            return ((DataBufferByte)dbuf).getData();
        }
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        int n2 = w2 * h2;
        byte[] bytes = new byte[n2 * 3];
        for (int i2 = 0; i2 < n2; ++i2) {
            int x2 = i2 % w2;
            int y2 = i2 / h2;
            int rgb = image.getRGB(x2, y2);
            bytes[i2 * 3 + 0] = (byte)(rgb >> 16 & 0xFF);
            bytes[i2 * 3 + 1] = (byte)(rgb >> 8 & 0xFF);
            bytes[i2 * 3 + 2] = (byte)(rgb & 0xFF);
        }
        return bytes;
    }
}

