/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded;

import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.expanded.ExpandedPair;
import java.util.List;

final class BitArrayBuilder {
    private BitArrayBuilder() {
    }

    static BitArray buildBitArray(List<ExpandedPair> pairs) {
        int i2;
        int charNumber = (pairs.size() << 1) - 1;
        if (pairs.get(pairs.size() - 1).getRightChar() == null) {
            --charNumber;
        }
        int size = 12 * charNumber;
        BitArray binary = new BitArray(size);
        int accPos = 0;
        ExpandedPair firstPair = pairs.get(0);
        int firstValue = firstPair.getRightChar().getValue();
        for (i2 = 11; i2 >= 0; --i2) {
            if ((firstValue & 1 << i2) != 0) {
                binary.set(accPos);
            }
            ++accPos;
        }
        for (i2 = 1; i2 < pairs.size(); ++i2) {
            ExpandedPair currentPair = pairs.get(i2);
            int leftValue = currentPair.getLeftChar().getValue();
            for (int j2 = 11; j2 >= 0; --j2) {
                if ((leftValue & 1 << j2) != 0) {
                    binary.set(accPos);
                }
                ++accPos;
            }
            if (currentPair.getRightChar() == null) continue;
            int rightValue = currentPair.getRightChar().getValue();
            for (int j3 = 11; j3 >= 0; --j3) {
                if ((rightValue & 1 << j3) != 0) {
                    binary.set(accPos);
                }
                ++accPos;
            }
        }
        return binary;
    }
}

