/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.detector;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int[] INDEXES_START_PATTERN = new int[]{0, 4, 1, 5};
    private static final int[] INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
    private static final int INTEGER_MATH_SHIFT = 8;
    private static final int PATTERN_MATCH_RESULT_SCALE_FACTOR = 256;
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 204;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int ROW_STEP = 5;
    private static final int BARCODE_MIN_HEIGHT = 10;

    private Detector() {
    }

    public static PDF417DetectorResult detect(BinaryBitmap image, Map<DecodeHintType, ?> hints, boolean multiple) throws NotFoundException {
        BitMatrix bitMatrix = image.getBlackMatrix();
        List<ResultPoint[]> barcodeCoordinates = Detector.detect(multiple, bitMatrix);
        if (barcodeCoordinates.isEmpty()) {
            Detector.rotate180(bitMatrix);
            barcodeCoordinates = Detector.detect(multiple, bitMatrix);
        }
        return new PDF417DetectorResult(bitMatrix, barcodeCoordinates);
    }

    private static List<ResultPoint[]> detect(boolean multiple, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> barcodeCoordinates = new ArrayList<ResultPoint[]>();
        int row = 0;
        int column = 0;
        boolean foundBarcodeInRow = false;
        while (row < bitMatrix.getHeight()) {
            ResultPoint[] vertices = Detector.findVertices(bitMatrix, row, column);
            if (vertices[0] == null && vertices[3] == null) {
                if (!foundBarcodeInRow) break;
                foundBarcodeInRow = false;
                column = 0;
                for (ResultPoint[] barcodeCoordinate : barcodeCoordinates) {
                    if (barcodeCoordinate[1] != null) {
                        row = (int)Math.max((float)row, barcodeCoordinate[1].getY());
                    }
                    if (barcodeCoordinate[3] == null) continue;
                    row = Math.max(row, (int)barcodeCoordinate[3].getY());
                }
                row += 5;
                continue;
            }
            foundBarcodeInRow = true;
            barcodeCoordinates.add(vertices);
            if (!multiple) break;
            if (vertices[2] != null) {
                column = (int)vertices[2].getX();
                row = (int)vertices[2].getY();
                continue;
            }
            column = (int)vertices[4].getX();
            row = (int)vertices[4].getY();
        }
        return barcodeCoordinates;
    }

    static void rotate180(BitMatrix bitMatrix) {
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BitArray firstRowBitArray = new BitArray(width);
        BitArray secondRowBitArray = new BitArray(width);
        BitArray tmpBitArray = new BitArray(width);
        for (int y2 = 0; y2 < height + 1 >> 1; ++y2) {
            firstRowBitArray = bitMatrix.getRow(y2, firstRowBitArray);
            bitMatrix.setRow(y2, Detector.mirror(bitMatrix.getRow(height - 1 - y2, secondRowBitArray), tmpBitArray));
            bitMatrix.setRow(height - 1 - y2, Detector.mirror(firstRowBitArray, tmpBitArray));
        }
    }

    static BitArray mirror(BitArray input, BitArray result) {
        result.clear();
        int size = input.getSize();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!input.get(i2)) continue;
            result.set(size - 1 - i2);
        }
        return result;
    }

    private static ResultPoint[] findVertices(BitMatrix matrix, int startRow, int startColumn) {
        int height = matrix.getHeight();
        int width = matrix.getWidth();
        ResultPoint[] result = new ResultPoint[8];
        Detector.copyToResult(result, Detector.findRowsWithPattern(matrix, height, width, startRow, startColumn, START_PATTERN), INDEXES_START_PATTERN);
        if (result[4] != null) {
            startColumn = (int)result[4].getX();
            startRow = (int)result[4].getY();
        }
        Detector.copyToResult(result, Detector.findRowsWithPattern(matrix, height, width, startRow, startColumn, STOP_PATTERN), INDEXES_STOP_PATTERN);
        return result;
    }

    private static void copyToResult(ResultPoint[] result, ResultPoint[] tmpResult, int[] destinationIndexes) {
        for (int i2 = 0; i2 < destinationIndexes.length; ++i2) {
            result[destinationIndexes[i2]] = tmpResult[i2];
        }
    }

    private static ResultPoint[] findRowsWithPattern(BitMatrix matrix, int height, int width, int startRow, int startColumn, int[] pattern) {
        int stopRow;
        ResultPoint[] result = new ResultPoint[4];
        boolean found = false;
        int[] counters = new int[pattern.length];
        while (startRow < height) {
            int[] loc = Detector.findGuardPattern(matrix, startColumn, startRow, width, false, pattern, counters);
            if (loc != null) {
                while (startRow > 0) {
                    int[] previousRowLoc;
                    if ((previousRowLoc = Detector.findGuardPattern(matrix, startColumn, --startRow, width, false, pattern, counters)) != null) {
                        loc = previousRowLoc;
                        continue;
                    }
                    ++startRow;
                    break;
                }
                result[0] = new ResultPoint(loc[0], startRow);
                result[1] = new ResultPoint(loc[1], startRow);
                found = true;
                break;
            }
            startRow += 5;
        }
        if (found) {
            int skippedRowCount = 0;
            int[] previousRowLoc = new int[]{(int)result[0].getX(), (int)result[1].getX()};
            for (stopRow = startRow + 1; stopRow < height; ++stopRow) {
                int[] loc = Detector.findGuardPattern(matrix, previousRowLoc[0], stopRow, width, false, pattern, counters);
                if (loc != null && Math.abs(previousRowLoc[0] - loc[0]) < 5 && Math.abs(previousRowLoc[1] - loc[1]) < 5) {
                    previousRowLoc = loc;
                    skippedRowCount = 0;
                    continue;
                }
                if (skippedRowCount > 25) break;
                ++skippedRowCount;
            }
            result[2] = new ResultPoint(previousRowLoc[0], stopRow -= skippedRowCount + 1);
            result[3] = new ResultPoint(previousRowLoc[1], stopRow);
        }
        if (stopRow - startRow < 10) {
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = null;
            }
        }
        return result;
    }

    private static int[] findGuardPattern(BitMatrix matrix, int column, int row, int width, boolean whiteFirst, int[] pattern, int[] counters) {
        int x2;
        int patternStart;
        Arrays.fill(counters, 0, counters.length, 0);
        int patternLength = pattern.length;
        boolean isWhite = whiteFirst;
        int pixelDrift = 0;
        for (patternStart = column; matrix.get(patternStart, row) && patternStart > 0 && pixelDrift++ < 3; --patternStart) {
        }
        int counterPosition = 0;
        for (x2 = patternStart; x2 < width; ++x2) {
            boolean pixel = matrix.get(x2, row);
            if (pixel ^ isWhite) {
                int n2 = counterPosition;
                counters[n2] = counters[n2] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                if (Detector.patternMatchVariance(counters, pattern, 204) < 107) {
                    return new int[]{patternStart, x2};
                }
                patternStart += counters[0] + counters[1];
                System.arraycopy(counters, 2, counters, 0, patternLength - 2);
                counters[patternLength - 2] = 0;
                counters[patternLength - 1] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite = !isWhite;
        }
        if (counterPosition == patternLength - 1 && Detector.patternMatchVariance(counters, pattern, 204) < 107) {
            return new int[]{patternStart, x2 - 1};
        }
        return null;
    }

    private static int patternMatchVariance(int[] counters, int[] pattern, int maxIndividualVariance) {
        int numCounters = counters.length;
        int total = 0;
        int patternLength = 0;
        for (int i2 = 0; i2 < numCounters; ++i2) {
            total += counters[i2];
            patternLength += pattern[i2];
        }
        if (total < patternLength) {
            return Integer.MAX_VALUE;
        }
        int unitBarWidth = (total << 8) / patternLength;
        maxIndividualVariance = maxIndividualVariance * unitBarWidth >> 8;
        int totalVariance = 0;
        for (int x2 = 0; x2 < numCounters; ++x2) {
            int variance;
            int counter = counters[x2] << 8;
            int scaledPattern = pattern[x2] * unitBarWidth;
            int n2 = variance = counter > scaledPattern ? counter - scaledPattern : scaledPattern - counter;
            if (variance > maxIndividualVariance) {
                return Integer.MAX_VALUE;
            }
            totalVariance += variance;
        }
        return totalVariance / total;
    }
}

