/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int numDataCodewords, byte[] codewords) {
        this.numDataCodewords = numDataCodewords;
        this.codewords = codewords;
    }

    static DataBlock[] getDataBlocks(byte[] rawCodewords, Version version, ErrorCorrectionLevel ecLevel) {
        int numCodewords;
        int longerBlocksStartAt;
        int i2;
        Version.ECB[] ecBlockArray;
        if (rawCodewords.length != version.getTotalCodewords()) {
            throw new IllegalArgumentException();
        }
        Version.ECBlocks ecBlocks = version.getECBlocksForLevel(ecLevel);
        int totalBlocks = 0;
        for (Version.ECB ecBlock : ecBlockArray = ecBlocks.getECBlocks()) {
            totalBlocks += ecBlock.getCount();
        }
        DataBlock[] result = new DataBlock[totalBlocks];
        int numResultBlocks = 0;
        for (Version.ECB ecBlock : ecBlockArray) {
            for (i2 = 0; i2 < ecBlock.getCount(); ++i2) {
                int numDataCodewords = ecBlock.getDataCodewords();
                int numBlockCodewords = ecBlocks.getECCodewordsPerBlock() + numDataCodewords;
                result[numResultBlocks++] = new DataBlock(numDataCodewords, new byte[numBlockCodewords]);
            }
        }
        int shorterBlocksTotalCodewords = result[0].codewords.length;
        for (longerBlocksStartAt = result.length - 1; longerBlocksStartAt >= 0 && (numCodewords = result[longerBlocksStartAt].codewords.length) != shorterBlocksTotalCodewords; --longerBlocksStartAt) {
        }
        ++longerBlocksStartAt;
        int shorterBlocksNumDataCodewords = shorterBlocksTotalCodewords - ecBlocks.getECCodewordsPerBlock();
        int rawCodewordsOffset = 0;
        for (i2 = 0; i2 < shorterBlocksNumDataCodewords; ++i2) {
            for (int j2 = 0; j2 < numResultBlocks; ++j2) {
                result[j2].codewords[i2] = rawCodewords[rawCodewordsOffset++];
            }
        }
        for (int j3 = longerBlocksStartAt; j3 < numResultBlocks; ++j3) {
            result[j3].codewords[shorterBlocksNumDataCodewords] = rawCodewords[rawCodewordsOffset++];
        }
        int max = result[0].codewords.length;
        for (int i3 = shorterBlocksNumDataCodewords; i3 < max; ++i3) {
            for (int j4 = 0; j4 < numResultBlocks; ++j4) {
                int iOffset = j4 < longerBlocksStartAt ? i3 : i3 + 1;
                result[j4].codewords[iOffset] = rawCodewords[rawCodewordsOffset++];
            }
        }
        return result;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

