/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.qrcode.encoder.ByteMatrix;

final class MaskUtil {
    private static final int N1 = 3;
    private static final int N2 = 3;
    private static final int N3 = 40;
    private static final int N4 = 10;

    private MaskUtil() {
    }

    static int applyMaskPenaltyRule1(ByteMatrix matrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(matrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(matrix, false);
    }

    static int applyMaskPenaltyRule2(ByteMatrix matrix) {
        int penalty = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y2 = 0; y2 < height - 1; ++y2) {
            for (int x2 = 0; x2 < width - 1; ++x2) {
                byte value = array[y2][x2];
                if (value != array[y2][x2 + 1] || value != array[y2 + 1][x2] || value != array[y2 + 1][x2 + 1]) continue;
                ++penalty;
            }
        }
        return 3 * penalty;
    }

    static int applyMaskPenaltyRule3(ByteMatrix matrix) {
        int numPenalties = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                byte[] arrayY = array[y2];
                if (x2 + 6 < width && arrayY[x2] == 1 && arrayY[x2 + 1] == 0 && arrayY[x2 + 2] == 1 && arrayY[x2 + 3] == 1 && arrayY[x2 + 4] == 1 && arrayY[x2 + 5] == 0 && arrayY[x2 + 6] == 1 && (MaskUtil.isWhiteHorizontal(arrayY, x2 - 4, x2) || MaskUtil.isWhiteHorizontal(arrayY, x2 + 7, x2 + 11))) {
                    ++numPenalties;
                }
                if (y2 + 6 >= height || array[y2][x2] != 1 || array[y2 + 1][x2] != 0 || array[y2 + 2][x2] != 1 || array[y2 + 3][x2] != 1 || array[y2 + 4][x2] != 1 || array[y2 + 5][x2] != 0 || array[y2 + 6][x2] != 1 || !MaskUtil.isWhiteVertical(array, x2, y2 - 4, y2) && !MaskUtil.isWhiteVertical(array, x2, y2 + 7, y2 + 11)) continue;
                ++numPenalties;
            }
        }
        return numPenalties * 40;
    }

    private static boolean isWhiteHorizontal(byte[] rowArray, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            if (i2 < 0 || i2 >= rowArray.length || rowArray[i2] != 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteVertical(byte[][] array, int col, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            if (i2 < 0 || i2 >= array.length || array[i2][col] != 1) continue;
            return false;
        }
        return true;
    }

    static int applyMaskPenaltyRule4(ByteMatrix matrix) {
        int numDarkCells = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y2 = 0; y2 < height; ++y2) {
            byte[] arrayY = array[y2];
            for (int x2 = 0; x2 < width; ++x2) {
                if (arrayY[x2] != 1) continue;
                ++numDarkCells;
            }
        }
        int numTotalCells = matrix.getHeight() * matrix.getWidth();
        int fivePercentVariances = Math.abs(numDarkCells * 2 - numTotalCells) * 10 / numTotalCells;
        return fivePercentVariances * 10;
    }

    static boolean getDataMaskBit(int maskPattern, int x2, int y2) {
        int intermediate;
        switch (maskPattern) {
            case 0: {
                intermediate = y2 + x2 & 1;
                break;
            }
            case 1: {
                intermediate = y2 & 1;
                break;
            }
            case 2: {
                intermediate = x2 % 3;
                break;
            }
            case 3: {
                intermediate = (y2 + x2) % 3;
                break;
            }
            case 4: {
                intermediate = (y2 >>> 1) + x2 / 3 & 1;
                break;
            }
            case 5: {
                int temp = y2 * x2;
                intermediate = (temp & 1) + temp % 3;
                break;
            }
            case 6: {
                int temp = y2 * x2;
                intermediate = (temp & 1) + temp % 3 & 1;
                break;
            }
            case 7: {
                int temp = y2 * x2;
                intermediate = temp % 3 + (y2 + x2 & 1) & 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + maskPattern);
            }
        }
        return intermediate == 0;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix matrix, boolean isHorizontal) {
        int penalty = 0;
        int iLimit = isHorizontal ? matrix.getHeight() : matrix.getWidth();
        int jLimit = isHorizontal ? matrix.getWidth() : matrix.getHeight();
        byte[][] array = matrix.getArray();
        for (int i2 = 0; i2 < iLimit; ++i2) {
            int numSameBitCells = 0;
            byte prevBit = -1;
            for (int j2 = 0; j2 < jLimit; ++j2) {
                byte bit;
                byte by = bit = isHorizontal ? array[i2][j2] : array[j2][i2];
                if (bit == prevBit) {
                    ++numSameBitCells;
                    continue;
                }
                if (numSameBitCells >= 5) {
                    penalty += 3 + (numSameBitCells - 5);
                }
                numSameBitCells = 1;
                prevBit = bit;
            }
            if (numSameBitCells < 5) continue;
            penalty += 3 + (numSameBitCells - 5);
        }
        return penalty;
    }
}

