/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.conn.Wire;

@NotThreadSafe
class LoggingInputStream
extends InputStream {
    private final InputStream in;
    private final Wire wire;

    public LoggingInputStream(InputStream in, Wire wire) {
        this.in = in;
        this.wire = wire;
    }

    public int read() throws IOException {
        int b2 = this.in.read();
        if (b2 != -1) {
            this.wire.input(b2);
        }
        return b2;
    }

    public int read(byte[] b2) throws IOException {
        int bytesRead = this.in.read(b2);
        if (bytesRead != -1) {
            this.wire.input(b2, 0, bytesRead);
        }
        return bytesRead;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int bytesRead = this.in.read(b2, off, len);
        if (bytesRead != -1) {
            this.wire.input(b2, off, bytesRead);
        }
        return bytesRead;
    }

    public long skip(long n2) throws IOException {
        return super.skip(n2);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        super.reset();
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

